package com.ejie.ab04b.constantes;

/**
 * @author GFI-NORTE
 * 
 */
public enum TipoTareaFlujo {

	// APERTURA
	APERTURA("apertura"), //

	// ESTUDIO
	ESTUDIO("estudio"), //

	// ESTUDIO_AUTOMATICO
	ESTUDIO_AUTOMATICO("estudio_automatico"), //
	
	// ESTUDIO_CORRECTO
	ESTUDIO_CORRECTO("estudio_correcto"),

	// REQUERIMIENTO
	ADJUNTAR_DOC_REQUERIMIENTO("adjuntar_doc_requerimiento"), //
	CREATENOTI_REQUERIMIENTO("createnoti_requerimiento"), //
	REGISTRA_REQUERIMIENTO_POSTAL("registra_requerimiento_postal"), //
	ACUSE_REQUERIMIENTO("acuse_requerimiento"), //
	ACUSE_REQUERIMIENTO_POSTAL("acuse_requerimiento_postal"), //

	// COMUNICACION_CONTRATISTA
	ADJUNTAR_CARTA_CONTRATISTA("adjuntar_carta_contratista"), //
	ENVIAR_COMUNICACION_CONTRATISTA("enviar_comunicacion_contratista"), //
	REGISTRACOMUNIC_CONTRATISTA_POSTAL("registracomunic_contratista_postal"), //

	// COMUNICACION_OS2
	ADJUNTAR_COMUNICACION_OS2("adjuntar_comunicacion_os2"), //
	ENVIAR_COMUNICACION_OS2("enviar_comunicacion_os2"), //
	REGISTRACOMUNIC_OS2_POSTAL("registracomunic_os2_postal"), //

	// COMUNICACION_OS2OS3
	ADJUNTAR_COMUNICACION_OS3("adjuntar_comunicacion_os3"), //
	ENVIAR_COMUNICACION_OS2_OS3("enviar_comunicacion_os2_os3"), //
	REGISTRACOMUNIC_OS2OS3_POSTAL("registracomunic_os2_os3_postal"), //

	// CAMBIO_COORDINADOR
	ADJUNTAR_CARTA_CAMBIO_COORDINADOR_CONTRATISTA(
			"adjuntar_comunic_cambio_coordinador_contratista"), //
	ENVAIR_COMUNICACION_CAMBIOCOORDINADOR_CONTRATISTA(
			"enviar_comunic_cambio_coordinador_contratista"), //
	REGISTRA_CARTA_CAMBIO_COORDINADOR_CONTRATISTA_POSTAL(
			"registra_cambio_coordinador_contratista_postal"), //

	// COMUNICACION_OS2_SIN
	// ADJUNTAR_COMUNICACION_OS2, //
	// ENVIAR_COMUNICACION_OS2, //
	// REGISTRACOMUNIC_OS2_POSTAL, //

	// COMUNICACION_OS2OS3_SIN
	// ADJUNTAR_COMUNICACION_OS3, //
	// ENVIAR_COMUNICACION_OS2_OS3, //
	// REGISTRACOMUNIC_OS2OS3_POSTAL, //

	// SOLICITAR_INFORME_VISITA
	SOLICITAR_DOCU("solicitar_docu"), //
	REGISTRA_SOLICITUD_SALIDA("registra_solicitud_salida"), //
	REGISTRA_SOLICITUD_ENTRADA("registra_solicitud_entrada"), //

	// APORTAR_INFORME_VISITA
	// OBTENER_FOLDERNUMBER, //
	ADJUNTAR_INFORME("adjuntar_informe"), //
	ADJUNTAR_INFORME_INSPECCION(
			"adjuntar_informe_inspeccion"), REGISTRA_INFORME_SALIDA(
					"registra_informe_salida"), //
	REGISTRA_INFORME_ENTRADA("registra_informe_entrada"), //
	// CONSOLIDAR_FECHA_INFORME(""), //

	SUBSANACION("subsanacion"), //
	APORTACION_DOCUMENTACION("aportacion_documentacion"),

	// COMUNICACION_INCOMPLETA
	COMUNICACION_INCOMPLETA("comunicacion_incompleta"),
	
	// CIERRE
	CIERRE("cierre"), //
	CONSOLIDAR_FECHA_CIERRE(""); //

	private String taskId;

	/**
	 * Constructor privado.
	 * 
	 * taskId String
	 *
	 * @param taskId
	 *            the task id
	 */
	private TipoTareaFlujo(String taskId) {
		this.taskId = taskId;
	}

	/**
	 * Gets the task id.
	 * 
	 * String
	 *
	 * @return the task id
	 */
	public String getTaskId() {
		return this.taskId;
	}

	/**
	 * Es equivalente.
	 * 
	 * taskId String boolean
	 *
	 * @param taskId
	 *            the task id
	 * @return true, if successful
	 */
	public boolean esEquivalente(String taskId) {

		return this.getTaskId().equals(taskId);
	}

}
